/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.levelgen.structure.LegacyStructureDataHandler;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.bukkit.Bukkit;
import org.spigotmc.SpigotConfig;

public class ChunkStorage
implements AutoCloseable {
    public static final int f_196910_ = 1493;
    private final IOWorker f_63495_;
    protected final DataFixer f_63496_;
    @Nullable
    private LegacyStructureDataHandler f_63497_;

    public ChunkStorage(Path p_196912_, DataFixer p_196913_, boolean p_196914_) {
        this.f_63496_ = p_196913_;
        this.f_63495_ = new IOWorker(p_196912_, p_196914_, "chunk");
    }

    private boolean check(ServerChunkCache cps, int x, int z) throws IOException {
        CompoundTag nbt;
        ChunkPos pos = new ChunkPos(x, z);
        if (cps != null) {
            Preconditions.checkState((boolean)Bukkit.isPrimaryThread(), (Object)"primary thread");
            if (cps.m_5563_(x, z)) {
                return true;
            }
        }
        if ((nbt = this.m_63512_(pos)) != null) {
            CompoundTag level = nbt.m_128469_("Level");
            if (level.m_128471_("TerrainPopulated")) {
                return true;
            }
            ChunkStatus status = ChunkStatus.m_62397_(level.m_128461_("Status"));
            if (status != null && status.m_62427_(ChunkStatus.f_62322_)) {
                return true;
            }
        }
        return false;
    }

    public CompoundTag upgradeChunkTag(ResourceKey<Level> p_188289_, Supplier<DimensionDataStorage> p_188290_, CompoundTag p_188291_, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> p_188292_, ChunkPos pos, @Nullable LevelAccessor generatoraccess) throws IOException {
        boolean belowZeroGenerationInExistingChunks;
        CompoundTag level;
        int i = ChunkStorage.m_63505_(p_188291_);
        if (i < 1466 && (level = p_188291_.m_128469_("Level")).m_128471_("TerrainPopulated") && !level.m_128471_("LightPopulated")) {
            ServerChunkCache cps;
            ServerChunkCache serverChunkCache = cps = generatoraccess == null ? null : ((ServerLevel)generatoraccess).m_7726_();
            if (this.check(cps, pos.f_45578_ - 1, pos.f_45579_) && this.check(cps, pos.f_45578_ - 1, pos.f_45579_ - 1) && this.check(cps, pos.f_45578_, pos.f_45579_ - 1)) {
                level.m_128379_("LightPopulated", true);
            }
        }
        if (i < 1493 && (p_188291_ = NbtUtils.m_129218_((DataFixer)this.f_63496_, (DataFixTypes)DataFixTypes.CHUNK, (CompoundTag)p_188291_, (int)i, (int)1493)).m_128469_("Level").m_128471_("hasLegacyStructureData")) {
            if (this.f_63497_ == null) {
                this.f_63497_ = LegacyStructureDataHandler.m_71331_(p_188289_, (DimensionDataStorage)p_188290_.get());
            }
            p_188291_ = this.f_63497_.m_71326_(p_188291_);
        }
        boolean stopBelowZero = false;
        boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((ServerLevel)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
        if (i <= 2730 && !belowZeroGenerationInExistingChunks) {
            stopBelowZero = ChunkStatus.f_62326_.m_62467_().equals(p_188291_.m_128469_("Level").m_128461_("Status"));
        }
        ChunkStorage.m_196918_(p_188291_, p_188289_, p_188292_);
        p_188291_ = NbtUtils.m_129213_((DataFixer)this.f_63496_, (DataFixTypes)DataFixTypes.CHUNK, (CompoundTag)p_188291_, (int)Math.max(1493, i));
        if (i < SharedConstants.m_183709_().getWorldVersion()) {
            p_188291_.m_128405_("DataVersion", SharedConstants.m_183709_().getWorldVersion());
        }
        if (stopBelowZero) {
            p_188291_.m_128359_("Status", ChunkStatus.f_62325_.m_62467_());
        }
        p_188291_.m_128473_("__context");
        return p_188291_;
    }

    public static void m_196918_(CompoundTag p_196919_, ResourceKey<Level> p_196920_, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> p_196921_) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_("dimension", p_196920_.m_135782_().toString());
        p_196921_.ifPresent(p_196917_ -> compoundtag.m_128359_("generator", p_196917_.m_135782_().toString()));
        p_196919_.m_128365_("__context", compoundtag);
    }

    public static int m_63505_(CompoundTag p_63506_) {
        return p_63506_.m_128425_("DataVersion", 99) ? p_63506_.m_128451_("DataVersion") : -1;
    }

    @Nullable
    public CompoundTag m_63512_(ChunkPos p_63513_) throws IOException {
        return this.f_63495_.m_63533_(p_63513_);
    }

    public void m_63502_(ChunkPos p_63503_, CompoundTag p_63504_) {
        this.f_63495_.m_63538_(p_63503_, p_63504_);
        if (this.f_63497_ != null) {
            this.f_63497_.m_71318_(p_63503_.m_45588_());
        }
    }

    public void m_63514_() {
        this.f_63495_.m_182498_(true).join();
    }

    @Override
    public void close() throws IOException {
        this.f_63495_.close();
    }

    public ChunkScanAccess m_196922_() {
        return this.f_63495_;
    }
}

